/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.events;

import com.flemmli97.improvedmobs.capability.PlayerDifficultyData;
import com.flemmli97.improvedmobs.capability.TileCapProvider;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.difficulty.DifficultyData;
import com.flemmli97.improvedmobs.network.PacketHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DifficultyHandler {
    @SubscribeEvent
    public void worldJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K) {
            PacketHandler.sendDifficultyToClient(DifficultyData.get(event.getEntity().field_70170_p), (ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void increaseDifficulty(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.END && !e.world.field_72995_K && e.world.func_234923_W_() == World.field_234918_g_) {
            boolean shouldIncrease = (Config.CommonConfig.ignorePlayers || !e.world.func_73046_m().func_184103_al().func_181057_v().isEmpty()) && e.world.func_72820_D() > (long)Config.CommonConfig.difficultyDelay;
            DifficultyData data = DifficultyData.get(e.world);
            if (Config.CommonConfig.shouldPunishTimeSkip) {
                long timeDiff = (int)Math.abs(e.world.func_72820_D() - data.getPrevTime());
                if (timeDiff > 2400L) {
                    long i = timeDiff / 2400L;
                    if (timeDiff - i * 2400L > (i + 1L) * 2400L - timeDiff) {
                        ++i;
                    }
                    while (i > 0L) {
                        data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease ? (Config.CommonConfig.doIMDifficulty ? Config.CommonConfig.increaseHandler.get(current.floatValue()) : 0.0f) : 0.0f), e.world.func_72820_D(), e.world.func_73046_m());
                        --i;
                    }
                }
            } else if (e.world.func_72820_D() - data.getPrevTime() > 2400L) {
                data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease ? (Config.CommonConfig.doIMDifficulty ? Config.CommonConfig.increaseHandler.get(current.floatValue()) : 0.0f) : 0.0f), e.world.func_72820_D(), e.world.func_73046_m());
            }
        }
    }

    @SubscribeEvent
    public void readOnDeath(PlayerEvent.Clone event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            event.getPlayer().getCapability(TileCapProvider.PlayerCap).ifPresent(data -> data.setDifficultyLevel(event.getOriginal().getCapability(TileCapProvider.PlayerCap).map(PlayerDifficultyData::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue()));
            PacketHandler.sendDifficultyToClient(DifficultyData.get(event.getPlayer().field_70170_p), (ServerPlayerEntity)event.getPlayer());
        }
    }
}

